<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_r_biaya_toefl".
 *
 * @property integer $biaya_id
 * @property string $membership
 * @property string $biaya_test
 *
 * @property BhsxPesertaToefl[] $bhsxPesertaToefls
 */
class BiayaToefl extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_r_biaya_toefl';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['membership', 'biaya_test'], 'string', 'max' => 100],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'biaya_id' => 'Biaya ID',
            'membership' => 'Membership',
            'biaya_test' => 'Biaya Test',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBhsxPesertaToefls()
    {
        return $this->hasMany(BhsxPesertaToefl::className(), ['biaya_id' => 'biaya_id']);
    }
}
