<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_dim_has_divisi".
 *
 * @property integer $dim_has_divisi_id
 * @property integer $dim_id
 * @property integer $divisi_id
 *
 * @property DimxDim $dim
 * @property BhsxRDivisi $divisi
 */
class DimHasDivisi extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_dim_has_divisi';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['dim_has_divisi_id'], 'required'],
            [['dim_has_divisi_id', 'dim_id', 'divisi_id'], 'integer'],
            [['dim_id'], 'exist', 'skipOnError' => true, 'targetClass' => Dim::className(), 'targetAttribute' => ['dim_id' => 'dim_id']],
            [['divisi_id'], 'exist', 'skipOnError' => true, 'targetClass' => Divisi::className(), 'targetAttribute' => ['divisi_id' => 'divisi_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'dim_has_divisi_id' => 'Dim Has Divisi ID',
            'dim_id' => 'Dim ID',
            'divisi_id' => 'Divisi ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDim()
    {
        return $this->hasOne(Dim::className(), ['dim_id' => 'dim_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDivisi()
    {
        return $this->hasOne(RDivisi::className(), ['divisi_id' => 'divisi_id']);
    }
}
