<?php

namespace backend\modules\bhsx\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\bhsx\models\DosenHasDivisi;

/**
 * DosenHasDivisiSearch represents the model behind the search form about `backend\modules\bhsx\models\DosenHasDivisi`.
 */
class DosenHasDivisiSearch extends DosenHasDivisi
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['dosen_has_divisi_id', 'dosen_id', 'divisi_id'], 'integer'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = DosenHasDivisi::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'dosen_has_divisi_id' => $this->dosen_has_divisi_id,
            'dosen_id' => $this->dosen_id,
            'divisi_id' => $this->divisi_id,
        ]);

        return $dataProvider;
    }
}
