<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_komentar".
 *
 * @property integer $komentar_id
 * @property integer $forum_id
 * @property string $isi_komentar
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxForum $forum
 */
class Komentar extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_komentar';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['forum_id', 'isi_komentar'], 'required'],
            [['forum_id', 'deleted'], 'integer'],
            [['isi_komentar'], 'string'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['forum_id'], 'exist', 'skipOnError' => true, 'targetClass' => Forum::className(), 'targetAttribute' => ['forum_id' => 'forum_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'komentar_id' => 'Komentar ID',
            'forum_id' => 'Forum ID',
            'isi_komentar' => 'Isi Komentar',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForum()
    {
        return $this->hasOne(Forum::className(), ['forum_id' => 'forum_id']);
    }
}
