<?php

namespace backend\modules\bhsx\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\bhsx\models\PesertaToefl;

/**
 * PesertaToeflSearch represents the model behind the search form about `backend\modules\bhsx\models\PesertaToefl`.
 */
class PesertaToeflSearch extends PesertaToefl
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['peserta_toefl_id', 'user_id', 'biaya_id', 'deleted'], 'integer'],
            [['nama_peserta', 'tanggal_lahir', 'alamat', 'telp', 'email', 'sumber_informasi', 'tanggal_ujian', 'tujuan_toefl', 'pengambilan_hasil', 'created_at', 'updated_at', 'created_by', 'updated_by', 'deleted_at', 'deleted_by'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PesertaToefl::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'peserta_toefl_id' => $this->peserta_toefl_id,
            'user_id' => $this->user_id,
            'tanggal_lahir' => $this->tanggal_lahir,
            'biaya_id' => $this->biaya_id,
            'tanggal_ujian' => $this->tanggal_ujian,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'deleted' => $this->deleted,
            'deleted_at' => $this->deleted_at,
        ]);

        $query->andFilterWhere(['like', 'nama_peserta', $this->nama_peserta])
            ->andFilterWhere(['like', 'alamat', $this->alamat])
            ->andFilterWhere(['like', 'telp', $this->telp])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'sumber_informasi', $this->sumber_informasi])
            ->andFilterWhere(['like', 'tujuan_toefl', $this->tujuan_toefl])
            ->andFilterWhere(['like', 'pengambilan_hasil', $this->pengambilan_hasil])
            ->andFilterWhere(['like', 'created_by', $this->created_by])
            ->andFilterWhere(['like', 'updated_by', $this->updated_by])
            ->andFilterWhere(['like', 'deleted_by', $this->deleted_by]);

        return $dataProvider;
    }
}
