Yii Framework 2 Change Log
==========================

2.0.0 beta under development
----------------------------
- Bug #1265: AssetController does not override 'js' and 'css' for compressed bundles (klimov-paul)
- Bug #1326: The `visible` setting for `DetailView` doesn't work as expected (qiangxue)
- Bug #1412: `FileValidator` and `ImageValidator` still trigger `uploadRequired` error in some case when `skipOnEmpty` is true and no upload is provided (qiangxue)
- Bug #1446: Logging while logs are processed causes infinite loop (qiangxue)
- Bug #1497: Localized view files are not correctly returned (mintao)
- Bug #1500: Log messages exported to files are not separated by newlines (omnilight, qiangxue)
- Bug #1504: Debug toolbar isn't loaded successfully in some environments when xdebug is enabled (qiangxue)
- Bug #1509: The SQL for creating Postgres RBAC tables is incorrect (qiangxue)
- Bug #1545: It was not possible to execute db Query twice, params where missing (cebe)
- Bug #1550: fixed the issue that JUI input widgets did not property input IDs.
- Bug #1654: Fixed the issue that a new message source object is generated for every new message being translated (qiangxue)
- Bug #1582: Error messages shown via client-side validation should not be double encoded (qiangxue)
- Bug #1591: StringValidator is accessing undefined property (qiangxue)
- Bug #1597: Added `enableAutoLogin` to basic and advanced application templates so "remember me" now works properly (samdark)
- Bug #1631: Charset is now explicitly set to UTF-8 when serving JSON (samdark)
- Bug #1635: `yii\jui\SliderInput` wasn't properly initialized (samdark)
- Bug #1659: MSSQL doesn't support limit (Ana1oliy)
- Bug #1686: ActiveForm is creating duplicated messages in error summary (qiangxue)
- Bug #1704: Incorrect regexp is used in `Inflector::camelize()` (qiangxue)
- Bug #1710: OpenId auth client does not request required attributes correctly (klimov-paul)
- Bug #1798: Fixed label attributes for array fields (zhuravljov)
- Bug #1800: Better check for `$_SERVER['HTTPS']` in `yii\web\Request::getIsSecureConnection()` (ginus, samdark)
- Bug #1812: Hide potential warning message due to race condition occurring to `Session::regenerateID()` call (qiangxue)
- Bug #1827: Debugger toolbar is loaded twice if an action is calling `run()` to execute another action (qiangxue)
- Bug #1868: Added ability to exclude tables from FixtureController apply/clear actions. (Ragazzo)
- Bug #1869: Fixed tables clearing. `TRUNCATE` changed to `DELETE` to avoid postgresql tables checks (and truncating all tables) (Ragazzo)
- Bug #1870: Validation errors weren't properly translated when using clientside validation (samdark)
- Bug #1930: Fixed domain based URL matching for website root (samdark)
- Bug #1937: Fixed wrong behavior or advanced app's `init --env` when called without parameter actually specified (samdark)
- Bug #1959: `Html::activeCheckbox` wasn't respecting custom values for checked/unchecked state (klevron, samdark)
- Bug #1965: `Controller::findLayoutFile()` returns incorrect file path when layout name starts with a slash (qiangxue)
- Bug #1992: In module scenario that use 'site/captcha' will get wrong refreshUrl (callmez)
- Bug #1993: afterFind event in AR is now called after relations have been populated (cebe, creocoder)
- Bug #1998: Unchecked required checkbox never pass client validation (klevron)
- Bug #2084: AssetController adjusting CSS URLs declared at same line fixed (klimov-paul)
- Bug #2091: `QueryBuilder::buildInCondition()` fails to handle array not starting with index 0 (qiangxue)
- Bug #2160: SphinxQL does not support OFFSET (qiangxue, romeo7)
- Bug #2209: When I18N message translation is missing source language is now used for formatting (samdark)
- Bug #2212: `yii\gridview\DataColumn` generates incorrect labels when used with nosql DB and there is no data (qiangxue)
- Bug #2298: Fixed the bug that Gii controller generator did not allow digit in the controller ID (qiangxue)
- Bug #2303: Fixed the bug that `yii\base\Theme::pathMap` did not support dynamic update with path aliases (qiangxue)
- Bug #2324: Fixed QueryBuilder bug when building a query with "query" option (mintao)
- Bug #2399: Fixed the bug that AssetBundle did not handle relative URLs correctly (qiangxue)
- Bug #2502: Unclear error message when `$_SERVER['DOCUMENT_ROOT']` is empty (samdark)
- Bug #2519: MessageSource removed translation messages when event handler was bound to `missingTranslation`-event (cebe)
- Bug #2527: Source language for `app` message category was always `en` no matter which application `sourceLanguage` was used (samdark)
- Bug #2559: Going back on browser history breaks GridView filtering with `Pjax` (tonydspaniard)
- Bug #2571: Fixed the bug that batchInsert will fail for SQLite if the values contain null or boolean false (qiangxue)
- Bug #2607: `yii message` tool wasn't updating `message` table (mitalcoi)
- Bug #2624: Html::textArea() should respect "name" option. (qiangxue)
- Bug #2653: Fixed the bug that unsetting an unpopulated AR relation would trigger exception (qiangxue)
- Bug #2681: Fixed the bug of php build-in server https://bugs.php.net/bug.php?id=66606 (dizews)
- Bug #2683: Fixed the bug that batchInsert will fail for MySQL if the values contain boolean false (qiangxue)
- Bug #2695: Fixed the issue that `FileValidator::isEmpty()` always returns true for validate multiple files (ZhandosKz)
- Bug #2739: Fixed the issue that `CreateAction::run()` was using obsolete `Controller::createAbsoluteUrl()` method (tonydspaniard)
- Bug #2740: Fixed the issue that `CaptchaAction::run()` was using obsolete `Controller::createUrl()` method (tonydspaniard)
- Bug #2760: Fixed GridView `filterUrl` parameters (qiangxue, AlexGx)
- Bug #2834: When overriding i18n translation sources from config using `app*` or `yii*` default `app` and `yii` sources were not removed (samdark)
- Bug: Fixed `Call to a member function registerAssetFiles() on a non-object` in case of wrong `sourcePath` for an asset bundle (samdark)
- Bug: Fixed incorrect event name for `yii\jui\Spinner` (samdark)
- Bug: Json::encode() did not handle objects that implement JsonSerializable interface correctly (cebe)
- Bug: Fixed issue with tabular input on ActiveField::radio() and ActiveField::checkbox() (jom)
- Bug: Fixed the issue that query cache returns the same data for the same SQL but different query methods (qiangxue)
- Bug: Fixed URL parsing so it's now properly giving 404 for URLs like `http://example.com//////site/about` (samdark)
- Bug: Fixed `HelpController::getModuleCommands` issue where it attempts to scan a module's controller directory when it doesn't exist (jom)
- Bug: Fixed an issue with FileHelper and not accessible directories which resulted in endless loop (cebe)
- Bug: Fixed `$model->load($data)` returned `true` if `$data` and `formName` were empty (samdark)
- Bug: Fixed issue with `ActiveRelationTrait` preventing `ActiveQuery` from clearing events and behaviors on clone (jom)
- Bug: `Query::queryScalar` wasn't making `SELECT DISTINCT` queries subqueries (jom)
- Enh #46: Added Image extension based on [Imagine library](http://imagine.readthedocs.org) (tonydspaniard)
- Enh #364: Improve Inflector::slug with `intl` transliteration. Improved transliteration char map. (tonydspaniard)
- Enh #497: Removed `\yii\log\Target::logUser` and added `\yii\log\Target::prefix` to support customizing message prefix (qiangxue)
- Enh #797: Added support for validating multiple columns by `UniqueValidator` and `ExistValidator` (qiangxue)
- Enh #802: Added support for retrieving sub-array element or child object property through `ArrayHelper::getValue()` (qiangxue, cebe)
- Enh #938: Added `yii\web\View::renderAjax()` and `yii\web\Controller::renderAjax()` (qiangxue)
- Enh #1293: Replaced Console::showProgress() with a better approach. See Console::startProgress() for details (cebe)
- Enh #1406: DB Schema support for Oracle Database (p0larbeer, qiangxue)
- Enh #1437: Added ListView::viewParams (qiangxue)
- Enh #1467: Added support for organizing controllers in subdirectories (qiangxue)
- Enh #1469: ActiveRecord::find() now works with default conditions (default scope) applied by createQuery (cebe)
- Enh #1476: Add yii\web\Session::handler property (nineinchnick)
- Enh #1499: Added `ActionColumn::controller` property to support customizing the controller for handling GridView actions (qiangxue)
- Enh #1523: Query conditions now allow to use the NOT operator (cebe)
- Enh #1535: Improved `yii\web\User` to start session only when needed. Also prepared it for use without session. (qiangxue)
- Enh #1562: Added `yii\bootstrap\Tabs::linkOptions` (kartik-v)
- Enh #1572: Added `yii\web\Controller::createAbsoluteUrl()` (samdark)
- Enh #1579: throw exception when the given AR relation name does not match in a case sensitive manner (qiangxue)
- Enh #1581: Added `ActiveQuery::joinWith()` and `ActiveQuery::innerJoinWith()` to support joining with relations (qiangxue)
- Enh #1585: added schema parameter to createAbsoluteUrl() to force 'http' or 'https' (cebe)
- Enh #1601: Added support for tagName and encodeLabel parameters in ButtonDropdown (omnilight)
- Enh #1611: Added `BaseActiveRecord::markAttributeDirty()` (qiangxue)
- Enh #1633: Advanced application template now works with MongoDB by default (samdark)
- Enh #1634: Use masked CSRF tokens to prevent BREACH exploits (qiangxue)
- Enh #1641: Added `BaseActiveRecord::updateAttributes()` (qiangxue)
- Enh #1646: Added postgresql `QueryBuilder::checkIntegrity` and `QueryBuilder::resetSequence` (Ragazzo)
- Enh #1645: Added `Connection::$pdoClass` property (Ragazzo)
- Enh #1645: Added support for nested DB transactions (qiangxue)
- Enh #1681: Added support for automatically adjusting the "for" attribute of label generated by `ActiveField::label()` (qiangxue)
- Enh #1706: Added support for registering a single JS/CSS file with dependency (qiangxue)
- Enh #1773: keyPrefix property of Cache is not restricted to alnum characters anymore, however it is still recommended (cebe)
- Enh #1809: Added support for building "EXISTS" and "NOT EXISTS" query conditions (abdrasulov)
- Enh #1839: Added support for getting file extension and basename from uploaded file (anfrantic)
- Enh #1852: ActiveRecord::tableName() now returns table name using DbConnection::tablePrefix (creocoder)
- Enh #1881: Improved `yii\bootstrap\NavBar` with `containerOptions`, `innerContainerOptions` and `renderInnerContainer` (creocoder)
- Enh #1894: The path aliases `@webroot` and `@web` are now available right after the application is initialized (qiangxue)
- Enh #1921: Grid view ActionColumn now allow to name buttons like `{controller/action}` (creocoder)
- Enh #1973: `yii message/extract` is now able to generate `.po` files (SergeiKutanov, samdark)
- Enh #1984: ActionFilter will now mark event as handled when action run is aborted (cebe)
- Enh #2003: Added `filter` property to `ExistValidator` and `UniqueValidator` to support adding additional filtering conditions (qiangxue)
- Enh #2008: `yii message/extract` is now able to save translation strings to database (kate-kate, samdark)
- Enh #2043: Added support for custom request body parsers (danschmidt5189, cebe)
- Enh #2051: Do not save null data into database when using RBAC (qiangxue)
- Enh #2054: Added support for using custom application configuration with the console command runner (qiangxue)
- Enh #2079:
	- i18n now falls back to `en` from `en-US` if message translation isn't found (samdark)
	- View now falls back to `en` from `en-US` if file not found (samdark)
	- Default `sourceLanguage` and `language` are now `en` (samdark)
- Enh #2101: Gii is now using model labels when generating search (thiagotalma)
- Enh #2102: DetailView now allow use `category.name` as attribute name (creocoder)
- Enh #2102: DetailView now allow use custom label in string format like `name:format:label` (creocoder)
- Enh #2103: Renamed AccessDeniedHttpException to ForbiddenHttpException, added new commonly used HTTP exception classes (danschmidt5189)
- Enh #2124: Added support for UNION ALL queries (Ivan Pomortsev, iworker)
- Enh #2132: Allow url of CSS and JS files registered in yii\web\View to be url alias (cebe)
- Enh #2144: `Html` helper now supports rendering "data" attributes (qiangxue)
- Enh #2156: `yii migrate` now automatically creates `migrations` directory if it does not exist (samdark)
- Enh:#2211: Added typecast database types into php types (dizews)
- Enh #2240: Improved `yii\web\AssetManager::publish()`, `yii\web\AssetManager::getPublishedPath()` and `yii\web\AssetManager::getPublishedUrl()` to support aliases (vova07)
- Enh #2325: Adding support for the `X-HTTP-Method-Override` header in `yii\web\Request::getMethod()` (pawzar)
- Enh #2364: Take into account current error reporting level in error handler (gureedo)
- Enh #2387: Added support for fetching data from database in batches (nineinchnick, qiangxue)
- Enh #2392: Added `addCssStyle()`, `removeCssStyle()`, `cssStyleFromArray()` and `cssStyleToArray()` to `Html` (qiangxue, kartik-v, Alex-Code)
- Enh #2411: Added Gii extension generator (schmunk42)
- Enh #2415: Added support for inverse relations (qiangxue)
- Enh #2417: Added possibility to set `dataType` for `$.ajax` call in yii.activeForm.js (Borales)
- Enh #2436: Label of the attribute, which looks like `relatedModel.attribute`, will be received from the related model if it available (djagya)
- Enh #2490: `yii\db\Query::count()` and other query scalar methods now properly handle queries with GROUP BY clause (qiangxue)
- Enh #2491: Added support for using the same base class name of search model and data model in Gii (qiangxue)
- Enh #2499: Added ability to downgrade migrations by their absolute apply time (resurtm, gorcer)
- Enh #2525: Added support for formatting file sizes with `yii\base\Formatter` (VinceG)
- Enh #2526: Allow for null values in batchInsert (skotos)
- Enh #2646: Added support for specifying hostinfo in the pattern of a URL rule (qiangxue)
- Enh #2661: Added boolean column type support for SQLite (qiangxue)
- Enh #2670: Changed `console\Controller::globalOptions()` to `options($actionId)` to (make it possible to) differentiate options per action (hqx)
- Enh #2714: Added support for formatting time intervals relative to the current time with `yii\base\Formatter` (drenty)
- Enh #2726: Added `yii\db\ActiveRecord::loadDefaultValues()` that fills default values from DB schema (samdark)
- Enh #2729: Added `FilterValidator::skipOnArray` so that filters like `trim` will not fail for array inputs (qiangxue)
- Enh #2735: Added support for `DateTimeInterface` in `Formatter` (ivokund)
- Enh #2756: Added support for injecting custom `isEmpty` check for all validators (qiangxue)
- Enh #2775: Added `yii\base\Application::bootstrap` to support running bootstrap classes when starting an application (qiangxue)
- Enh: Added support for using arrays as option values for console commands (qiangxue)
- Enh: Added `favicon.ico` and `robots.txt` to default application templates (samdark)
- Enh: Added `Widget::autoIdPrefix` to support prefixing automatically generated widget IDs (qiangxue)
- Enh: Support for file aliases in console command 'message' (omnilight)
- Enh: Sort and Pagination can now create absolute URLs (cebe)
- Enh: Added support for using array-typed arguments for console commands (qiangxue)
- Enh: Added support for installing packages conforming to PSR-4 standard (qiangxue)
- Enh: Better exception message when class cannot be loaded (samdark)
- Enh: `init` of advanced application now allows to specify answer for overwriting files via `init --overwrite=n` (samdark)
- Enh: Added `TableSchema::fullName` property (qiangxue)
- Enh: yii\codeception\TestCase now supports loading and using fixtures via Yii fixture framework (qiangxue)
- Enh: Added ability to get incoming headers (dizews)
- Enh: Added `beforeRun()` and `afterRun()` to `yii\base\Action` (qiangxue)
- Enh: Added support for using timeZone with `yii\base\Formatter` (dizews)
- Enh: Added `yii\web\View::POS_LOAD` (qiangxue)
- Enh: Added `yii\web\Response::clearOutputBuffers()` (qiangxue)
- Enh: Improved `QueryBuilder::buildLimit()` to support big numbers (qiangxue)
- Enh: Added support for building SQLs with sub-queries (qiangxue)
- Enh: Added `Pagination::getLinks()` (qiangxue)
- Enh: Added support for reading page size from query parameters by `Pagination` (qiangxue)
- Enh: LinkPager can now register relational link tags in the html header for prev, next, first and last page (cebe)
- Enh: Added `yii\web\UrlRuleInterface` and `yii\web\CompositeUrlRule` (qiangxue)
- Enh: Added `yii\web\Request::getAuthUser()` and `getAuthPassword()` (qiangxue)
- Chg #735: Added back `ActiveField::hiddenInput()` (qiangxue)
- Chg #1186: Changed `Sort` to use comma to separate multiple sort fields and use negative sign to indicate descending sort (qiangxue)
- Chg #1519: `yii\web\User::loginRequired()` now returns the `Response` object instead of exiting the application (qiangxue)
- Chg #1564: Removed `yii\web\Session::autoStart` and added `hasSessionId`. Session will be automatically started when accessing session data (qiangxue)
- Chg #1586: `QueryBuilder::buildLikeCondition()` will now escape special characters and use percentage characters by default (qiangxue)
- Chg #1610: `Html::activeCheckboxList()` and `Html::activeRadioList()` will submit an empty string if no checkbox/radio is selected (qiangxue)
- Chg #1643: Added default value for `Captcha::options` (qiangxue)
- Chg #1796: Removed `yii\base\Controller::getActionParams()` (samdark)
- Chg #1835: `CheckboxColumn` now renders checkboxes whose values are the corresponding data key values (qiangxue)
- Chg #1821: Changed default values for yii\db\Connection username and password to null (cebe)
- Chg #1844: `Response::sendFile()` and other file sending methods will not send the response (qiangxue)
- Chg #1852: DbConnection::tablePrefix default value now 'tbl_' (creocoder)
- Chg #1958: `beforeSubmit` in `yii.activeform` is now executed after validation and before form submission (6pblcb)
- Chg #2025: Removed ability to declare scopes in ActiveRecord (samdark)
- Chg #2043:
	- Renamed `yii\web\Request::acceptedLanguages` to `acceptableLanguages` (qiangxue)
	- Removed `yii\web\Request::getPost()`, `getPut()`, `getDelete()`, `getPatch()` in favor of `getBodyParam()` (cebe)
	- Renamed `yii\web\Request::get()` to `getQueryParams()` and `getRestParams()` to `getBodyParams()` (cebe)
	- Added `yii\web\Request::get($name = null, $defaultValue = null)` and `yii\web\Request::post($name = null, $defaultValue = null)` (samdark)
- Chg #2059: Implemented git-flavored file excluding/filtering for `FileHelper` (nineinchnick)
- Chg #2063: Removed `yii\web\Request::acceptTypes` and renamed `yii\web\Request::acceptedContentTypes` to `acceptableContentTypes` (qiangxue)
- Chg #2146: Removed `ActiveRelation` class and `ActiveRelationInterface`, moved the functionality to `ActiveQuery`.
             All relational queries are now directly served by `ActiveQuery` allowing to use custom scopes in relations
             and also to declare arbitrary queries as relations.
			 Also removed `ActiveRecordInterface::createActiveRelation()` (cebe)
- Chg #2157: The '*' category pattern will match all categories that do not match any other patterns listed in `I18N::translations` (qiangxue, Ragazzo)
- Chg #2161: Added ability to use `return` in `Widget::run` (samdark)
- Chg #2173: Removed `StringHelper::diff()`, Moved `phpspec/php-diff` dependency from `yiisoft/yii2` to `yiisoft/yii2-gii` (samdark)
- Chg #2175: QueryBuilder will now append UNION statements at the end of the primary SQL (qiangxue)
- Chg #2210: Mysql driver will now treat `tinyint(1)` as integer instead of boolean (qiangxue)
- Chg #2248: Renamed `yii\base\Model::DEFAULT_SCENARIO` to `yii\base\Model::SCENARIO_DEFAULT` (samdark)
- Chg #2281: Renamed `ActiveRecord::create()` to `populateRecord()` and changed signature. This method will not call instantiate() anymore (cebe)
- Chg #2405: The CSS class of `MaskedInput` now defaults to `form-control` (qiangxue)
- Chg #2426: Changed URL creation method signatures to be consistent (samdark)
- Chg #2544: Changed `DetailView`'s `name:format:label` to `attribute:format:label` to match `GridView` (samdark)
- Chg #2603: `yii\base\ErrorException` now extends `\ErrorException` (samdark)
- Chg #2629: `Module::controllerPath` is now read only, and all controller classes must be namespaced under `Module::controllerNamespace`. (qiangxue)
- Chg #2630: API changes for URLs generation (samdark, qiangxue, cebe)
	- Added `yii\helpers\Url`.
	- Removed `yii\helpers\Html::url`, use `yii\helpers\Url::to` instead.
	- Removed `yii\web\Controller::createUrl` and `yii\web\Controller::createAbsoluteUrl`, use `yii\helpers\Url::toRoute` instead.
	- Removed `yii\web\Controller::getCanonicalUrl`, use `yii\helpers\Url::canonical` instead.
- Chg #2691: Null parameters will not be included in the generated URLs by `UrlManager` (gonimar, qiangxue)
- Chg #2734: `FileCache::keyPrefix` defaults to empty string now (qiangxue)
- Chg: Renamed `yii\jui\Widget::clientEventsMap` to `clientEventMap` (qiangxue)
- Chg: Renamed `ActiveRecord::getPopulatedRelations()` to `getRelatedRecords()` (qiangxue)
- Chg: Renamed `attributeName` and `className` to `targetAttribute` and `targetClass` for `UniqueValidator` and `ExistValidator` (qiangxue)
- Chg: Added `yii\widgets\InputWidget::options` (qiangxue)
- Chg: Changed the signature of `urlCreator` and button creators for `yii\gridview\ActionColumn` (qiangxue)
- Chg: Updated HTMLPurified dependency to `4.6.*`.
- Chg: Changed Yii autoloader to support loading PSR-4 classes only (i.e. PEAR-styled classes not supported anymore) (qiangxue)
- Chg: Changed the directory structure according to PSR-4. You have to update your application `index.php`,
       `index-test.php` and `yii` files to point to the new location of `Yii.php` (qiangxue, cebe)
- Chg: Advanced app template: moved database connection DSN, login and password to `-local` config not to expose it to VCS (samdark)
- Chg: Renamed `yii\web\Request::acceptedLanguages` to `acceptableLanguages` (qiangxue)
- Chg: Removed implementation of `Arrayable` from `yii\Object` (qiangxue)
- Chg: The scripts in asset bundles are now registered in `View` at the end of `endBody()`. It was done in `endPage()` previously (qiangxue)
- Chg: Renamed `csrf-var` to `csrf-param` for CSRF header name (Dilip)
- Chg: The directory holding email templates is renamed from `mails` to `mail` (qiangxue)
- Chg: Renamed properties `fooVar` to `fooParam` for various classes (qiangxue)
	- Renamed `ActiveForm::ajaxVar` to `ajaxParam`
	- Renamed `Pagination::pageVar` to `pageParam`
	- Renamed `Sort::sortVar` to `sortParam`
	- Renamed `yii\web\Request::csrfVar` to `csrfParam`
	- Renamed `yii\web\Request::methodVar` to `methodParam`
	- Renamed `UrlManager::routeVar` to `routeParam`
	- Renamed `yii\web\Session::flashVar` to `flashParam`
	- Renamed `yii\web\User::idVar` to `idParam`
	- Renamed `yii\web\User::authTimeoutVar` to `authTimeoutParam`
	- Renamed `yii\web\User::returnUrlVar` to `returnUrlParam`
- Chg: Added `View::viewFile` and removed `ViewEvent::viewFile` (qiangxue)
- Chg: Changed `Controller::afterAction()`, `Module::afterAction()` and `ActionFilter::afterAction()` to pass `$result` by value instead of reference (qiangxue)
- Chg: `yii\base\Extension::init()` is renamed to `bootstrap()` (qiangxue)
- New #66: [Auth client library](https://github.com/yiisoft/yii2-authclient) OpenId, OAuth1, OAuth2 clients (klimov-paul)
- New #706: Added `yii\widgets\Pjax` and enhanced `GridView` to work with `Pjax` to support AJAX-update (qiangxue)
- New #1393: [Codeception testing framework integration](https://github.com/yiisoft/yii2-codeception) (Ragazzo)
- New #1438: [MongoDB integration](https://github.com/yiisoft/yii2-mongodb) ActiveRecord and Query (klimov-paul)
- New #1956: Implemented test fixture framework (qiangxue)
- New #2149: Added `yii\base\DynamicModel` to support ad-hoc data validation (qiangxue)
- New #2360: Added `AttributeBehavior` and `BlameableBehavior`, and renamed `AutoTimestamp` to `TimestampBehavior` (lucianobaraglia, qiangxue)
- New: Yii framework now comes with core messages in multiple languages
- New: Added yii\codeception\DbTestCase (qiangxue)


2.0.0 alpha, December 1, 2013
---------------------------

- Initial release.
- Official extensions released in this version:
  - [Twitter bootstrap 3.0](https://github.com/yiisoft/yii2-bootstrap)
  - [Jquery UI](https://github.com/yiisoft/yii2-jui)

  - [Debug Toolbar](https://github.com/yiisoft/yii2-debug)
  - [Gii code generator](https://github.com/yiisoft/yii2-gii)

  - [Elasticsearch integration](https://github.com/yiisoft/yii2-elasticsearch): ActiveRecord and Query
  - [Redis integration](https://github.com/yiisoft/yii2-redis): ActiveRecord, Cache and Session
  - [Sphinx integration](https://github.com/yiisoft/yii2-sphinx): ActiveRecord and Query

  - [Swiftmailer](https://github.com/yiisoft/yii2-swiftmailer)

  - [Smarty View Renderer](https://github.com/yiisoft/yii2-smarty)
  - [Twig View Renderer](https://github.com/yiisoft/yii2-twig)
